/*
 * Decompiled with CFR 0.152.
 */
package org.blocovermelho.ae2emicrafting.client.handler;

import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import appeng.core.localization.ItemModText;
import appeng.integration.modules.jeirei.EncodingHelper;
import appeng.menu.me.common.GridInventoryEntry;
import appeng.menu.me.common.IClientRepo;
import appeng.menu.me.items.PatternEncodingTermMenu;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_1860;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import org.blocovermelho.ae2emicrafting.client.handler.generic.Ae2BaseRecipeHandler;
import org.blocovermelho.ae2emicrafting.client.helper.RecipeUtils;
import org.blocovermelho.ae2emicrafting.client.helper.mapper.EmiStackHelper;
import org.blocovermelho.ae2emicrafting.client.helper.rendering.Result;
import org.jetbrains.annotations.Nullable;

public class Ae2PatternTerminalHandler<T extends PatternEncodingTermMenu>
extends Ae2BaseRecipeHandler<T> {
    public Ae2PatternTerminalHandler(Class<T> containerClass) {
        super(containerClass);
    }

    @Override
    protected Result transferRecipe(T menu, @Nullable class_1860<?> recipe, EmiRecipe emiRecipe, boolean doTransfer) {
        class_2960 recipeId = recipe != null ? recipe.method_8114() : null;
        boolean craftingRecipe = RecipeUtils.isCraftingRecipe(recipe, emiRecipe);
        if (craftingRecipe && !RecipeUtils.fitsIn3x3Grid(recipe)) {
            return Result.createFailed((class_2561)ItemModText.RECIPE_TOO_LARGE.text());
        }
        if (doTransfer) {
            if (craftingRecipe && recipeId != null) {
                EncodingHelper.encodeCraftingRecipe(menu, recipe, this.getGuiIngredientsForCrafting(emiRecipe), stack -> true);
            } else {
                EncodingHelper.encodeProcessingRecipe(menu, EmiStackHelper.ofInputs(emiRecipe), EmiStackHelper.ofOutputs(emiRecipe));
            }
        } else {
            IClientRepo repo = menu.getClientRepo();
            Set<AEKey> craftableKeys = repo != null ? repo.getAllEntries().stream().filter(GridInventoryEntry::isCraftable).map(GridInventoryEntry::getWhat).collect(Collectors.toSet()) : Set.of();
            return new Result.EncodeWithCraftables(craftableKeys);
        }
        return Result.createSuccessful();
    }

    private List<List<GenericStack>> getGuiIngredientsForCrafting(EmiRecipe emiRecipe) {
        ArrayList<List<GenericStack>> result = new ArrayList<List<GenericStack>>(9);
        for (int i = 0; i < 9; ++i) {
            ArrayList<GenericStack> stacks = new ArrayList<GenericStack>();
            if (i < emiRecipe.getInputs().size()) {
                for (EmiStack emiStack : ((EmiIngredient)emiRecipe.getInputs().get(i)).getEmiStacks()) {
                    GenericStack genericStack = EmiStackHelper.toGenericStack(emiStack);
                    if (genericStack == null || !(genericStack.what() instanceof AEItemKey)) continue;
                    stacks.add(genericStack);
                }
            }
            result.add(stacks);
        }
        return result;
    }
}

